#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
UDP客户端示例
"""

import socket
import time

def start_udp_client():
    """启动UDP客户端"""
    # 创建UDP socket对象
    client_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    
    try:
        # 服务器地址
        server_host = 'localhost'
        server_port = 9999
        server_address = (server_host, server_port)
        
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] UDP客户端启动，目标服务器 {server_host}:{server_port}")
        
        # 发送消息列表
        messages = [
            "Hello UDP Server!",
            "这是UDP通信测试",
            "无连接协议演示",
            "UDP消息结束"
        ]
        
        for message in messages:
            # 发送数据到服务器
            print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 发送消息: {message}")
            client_socket.sendto(message.encode('utf-8'), server_address)
            
            # 接收服务器响应
            response, server_addr = client_socket.recvfrom(1024)
            print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 服务器 {server_addr} 响应: {response.decode('utf-8')}")
            
            time.sleep(1)  # 等待1秒
            
    except Exception as e:
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] UDP客户端错误: {e}")
    finally:
        client_socket.close()
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] UDP客户端已关闭")

if __name__ == '__main__':
    start_udp_client()