# -*- coding: utf-8 -*-
"""目录操作测试脚本"""
import os
from pathlib import Path

print("=== 测试1: os模块基本操作 ===")
print(f"当前工作目录: {os.getcwd()}")
print(f"目录内容: {os.listdir('.')}")

# 创建测试目录
test_dir = 'test_subdir'
if not os.path.exists(test_dir):
    os.mkdir(test_dir)
    print(f"创建目录: {test_dir}")
else:
    print(f"目录已存在: {test_dir}")

print(f"检查目录是否存在: {os.path.exists(test_dir)}")
print(f"是否为目录: {os.path.isdir(test_dir)}")

print("\n=== 测试2: 路径操作 ===")
file_path = os.path.join(test_dir, 'test.txt')
print(f"拼接路径: {file_path}")
print(f"目录名: {os.path.dirname(file_path)}")
print(f"文件名: {os.path.basename(file_path)}")
print(f"分离路径: {os.path.split(file_path)}")
print(f"分离扩展名: {os.path.splitext(file_path)}")

print("\n=== 测试3: pathlib模块 ===")
path = Path('.')
print(f"当前路径: {path.absolute()}")
print(f"路径存在: {path.exists()}")
print(f"是否为目录: {path.is_dir()}")

# 创建文件
test_file = Path(test_dir) / 'pathlib_test.txt'
test_file.write_text('Hello from pathlib!', encoding='utf-8')
print(f"创建文件: {test_file}")
print(f"文件内容: {test_file.read_text(encoding='utf-8')}")

print("\n=== 测试4: 文件遍历 ===")
print("当前目录下的所有文件:")
for item in Path('.').iterdir():
    if item.is_file():
        print(f"  文件: {item.name}")
    elif item.is_dir():
        print(f"  目录: {item.name}/")

print("\n=== 测试5: 文件信息 ===")
for txt_file in Path('.').glob('*.txt'):
    stat = txt_file.stat()
    print(f"文件: {txt_file.name}")
    print(f"  大小: {stat.st_size} 字节")
    print(f"  修改时间: {stat.st_mtime}")