#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
TCP客户端示例
"""

import socket
import time

def start_client():
    """启动TCP客户端"""
    # 创建socket对象
    client_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    
    try:
        # 连接服务器
        host = 'localhost'
        port = 8888
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 正在连接服务器 {host}:{port}...")
        client_socket.connect((host, port))
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 已连接到服务器")
        
        # 发送消息
        messages = [
            "Hello, Server!",
            "这是第二条消息",
            "Python网络编程测试",
            "再见!"
        ]
        
        for message in messages:
            # 发送数据
            print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 发送消息: {message}")
            client_socket.send(message.encode('utf-8'))
            
            # 接收服务器响应
            response = client_socket.recv(1024)
            print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 服务器响应: {response.decode('utf-8')}")
            
            time.sleep(1)  # 等待1秒
            
    except Exception as e:
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 客户端错误: {e}")
    finally:
        client_socket.close()
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 客户端已断开连接")

if __name__ == '__main__':
    start_client()