"""这是一个示例模块
用于演示模块的基本概念和使用方法
"""

# 模块级别的变量
MODULE_VERSION = "1.0.0"
PI = 3.14159

# 模块级别的函数
def greet(name):
    """问候函数
    
    Args:
        name (str): 要问候的人的姓名
    
    Returns:
        str: 问候语
    """
    return f"Hello, {name}!"

def calculate_area(radius):
    """计算圆的面积
    
    Args:
        radius (float): 圆的半径
    
    Returns:
        float: 圆的面积
    """
    return PI * radius ** 2

# 模块级别的类
class Calculator:
    """简单的计算器类"""
    
    def __init__(self):
        """初始化计算器"""
        self.result = 0
    
    def add(self, x, y):
        """加法运算
        
        Args:
            x (float): 第一个数
            y (float): 第二个数
        
        Returns:
            float: 计算结果
        """
        self.result = x + y
        return self.result
    
    def multiply(self, x, y):
        """乘法运算
        
        Args:
            x (float): 第一个数
            y (float): 第二个数
        
        Returns:
            float: 计算结果
        """
        self.result = x * y
        return self.result

# 当模块被直接运行时执行的代码
if __name__ == "__main__":
    print("这是my_module模块的测试代码")
    print(f"模块版本: {MODULE_VERSION}")
    print(greet("Python"))
    
    calc = Calculator()
    print(f"5 + 3 = {calc.add(5, 3)}")
    print(f"圆的面积 (半径=2): {calculate_area(2)}")