#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
列表推导式演示代码
"""

# 基本列表推导式
print("=== 基本列表推导式 ===")
numbers = [1, 2, 3, 4, 5]
squares = [x**2 for x in numbers]
print(f"原始列表: {numbers}")
print(f"平方列表: {squares}")

# 条件过滤
print("\n=== 条件过滤 ===")
even_squares = [x**2 for x in numbers if x % 2 == 0]
print(f"偶数的平方: {even_squares}")

# 字符串处理
print("\n=== 字符串处理 ===")
words = ['hello', 'world', 'python', 'programming']
capitalized = [word.capitalize() for word in words if len(word) > 5]
print(f"长度大于5的单词首字母大写: {capitalized}")

# 嵌套列表推导式
print("\n=== 嵌套列表推导式 ===")
matrix = [[1, 2, 3], [4, 5, 6], [7, 8, 9]]
flattened = [num for row in matrix for num in row]
print(f"二维矩阵: {matrix}")
print(f"展平后: {flattened}")

# 性能对比
print("\n=== 性能对比 ===")
import time

# 使用列表推导式
start_time = time.time()
list_comp_result = [x**2 for x in range(10000)]
list_comp_time = time.time() - start_time

# 使用传统循环
start_time = time.time()
loop_result = []
for x in range(10000):
    loop_result.append(x**2)
loop_time = time.time() - start_time

print(f"列表推导式耗时: {list_comp_time:.6f}秒")
print(f"传统循环耗时: {loop_time:.6f}秒")
print(f"列表推导式比传统循环快 {loop_time/list_comp_time:.2f} 倍")